#property indicator_separate_window
#property indicator_buffers 6
#property indicator_color1 White
#property indicator_color2 Aqua
#property indicator_color3 Yellow
#property indicator_color4 Lime
#property indicator_color5 Red
#property indicator_color6 White
extern string Price_            = "0C, 1O, 2H, 3L, 4Md:(Md(HL/2)4), 5Tp:(Tp(HLC/3)5), 6WghC:(Wgh(HLCC/4)6)";
extern int    Price             = 6;
extern int    LengthCom         = 9;
extern string MAmode_           = "0 sma; 1 ema; 2 smma; 3 lwma";
extern int    MAmode            = 3;
extern color  UpColor           = Aqua;
extern color  DownColor         = Yellow;
extern color  chncolor          = White;
extern color  HighChanColor     = Lime;
extern color  LowChanColor      = Red;
extern color  zero2             = White;
extern color  ZeroLineUpColor   = Green;
extern color  ZeroLineDownColor = Red;
//extern bool   Plot_Chart        = FALSE;
extern double StDv              = 1.0;

int gi_unused_124 = 0;
int gi_128 = 0;
double gd_unused_132 = 0.0;
double gd_unused_140 = 0.0;
double gd_unused_148 = 0.0;
double gd_unused_156 = 0.0;
string gs_unused_164 = " ";
double gd_unused_172 = 0.0;
double gd_unused_180 = 0.0;
bool gi_188 = FALSE;
bool gi_192 = FALSE;
double Pic_macd[];
double MAonAr[];
double ggibuf_216[];
double UB[];
double LB[];
double zero[];
double MACD[];
double MA[];

int init() {
   IndicatorBuffers(8);
   SetIndexBuffer(0, Pic_macd);
   SetIndexBuffer(1, MAonAr);
   SetIndexBuffer(2, ggibuf_216);
   SetIndexBuffer(3, UB);
   SetIndexBuffer(4, LB);
   SetIndexBuffer(5, zero);
   SetIndexBuffer(6, MACD);
   SetIndexBuffer(7, MA);
   SetIndexStyle(0, DRAW_ARROW, 0, 2, chncolor);
   SetIndexArrow(0, 108);
   SetIndexStyle(1, DRAW_HISTOGRAM, 0, 4, UpColor);
   SetIndexStyle(2, DRAW_HISTOGRAM, 0, 4, DownColor);
   SetIndexStyle(3, DRAW_LINE, EMPTY, EMPTY, HighChanColor);
   SetIndexStyle(4, DRAW_LINE, EMPTY, EMPTY, LowChanColor);
   SetIndexStyle(5, DRAW_LINE, EMPTY, EMPTY, zero2);
   SetIndexLabel(0, "Pic_macd");
   SetIndexLabel(3, "UB");
   SetIndexLabel(4, "LB");
   SetIndexLabel(5, "zero");
   IndicatorShortName("MACD 3(m). ("+Price+", "+LengthCom+", "+MAmode+")");   
   return (0);
}

int start()
 {
   int vdigits = MarketInfo(NULL,MODE_DIGITS);
   if(vdigits<=2)int k=1;  else k=100;
   
   int counted_bars = IndicatorCounted();
   if (counted_bars > 0) counted_bars--;
   int limit = Bars - counted_bars;
   for (int i = 0; i < limit; i++) zero[i] = 0;
   for (i = 0; i < limit; i++) 
   MACD[i] = 100.0 * (iMA(NULL, 0, 1.2 * LengthCom, 0, MODE_EMA, Price, i) - iMA(NULL, 0, 2.5 * LengthCom, 0, MODE_EMA, Price, i))*k;
   int M_period = LengthCom;
   for (i = 0; i < limit; i++) 
   MA[i] = iMA(NULL, 0, M_period, 0, MODE_EMA, Price, i)*k;
   
   for (i = 0; i < limit; i++) 
   MAonAr[i] = iMAOnArray(MA, 0, M_period, 0, MODE_EMA, i)*k;
   
   for (i = 0; i < limit; i++) {
      MA[i] = (iMAOnArray(MAonAr, 0, M_period, 0, MODE_EMA, i) - iMAOnArray(MAonAr, 0, M_period, 0, MODE_EMA, i + 1)) / iMAOnArray(MAonAr,
         0, M_period, 0, MODE_EMA, i);
   }
   for (i = 0; i < limit; i++) MACD[i] += MA[i] + gi_128 / 2.0;
   for (i = 0; i < limit; i++) {
      UB[i] = iMAOnArray(MACD, 0, M_period, 0, MODE_EMA, i) + StDv * iStdDevOnArray(MACD, 0, M_period, 0, MAmode, i);
      LB[i] = iMAOnArray(MACD, 0, M_period, 0, MODE_EMA, i) - StDv * iStdDevOnArray(MACD, 0, M_period, 0, MAmode, i);
   }
   for (i = 0; i < limit; i++) {
      if (MACD[i] > MACD[i + 1]) 
        {
         Pic_macd[i] = EMPTY_VALUE;
         MAonAr[i] = MACD[i];
         ggibuf_216[i] = EMPTY_VALUE;
        } 
        else 
        {
         Pic_macd[i] = EMPTY_VALUE;
         MAonAr[i] = EMPTY_VALUE;
         ggibuf_216[i] = MACD[i];
        }
      if (gi_188 == FALSE) 
        {
         if (MACD[i] > UB[i])
          {
            gi_188 = TRUE;
            gi_192 = FALSE;
            Pic_macd[i] = MACD[i];
            MAonAr[i] = EMPTY_VALUE;
            ggibuf_216[i] = EMPTY_VALUE;
          }
      } 
      else 
      {
         if (gi_192 == FALSE) 
          {
            if (MACD[i] < LB[i]) 
            {
               gi_188 = FALSE;
               gi_192 = TRUE;
               Pic_macd[i] = MACD[i];
               MAonAr[i] = EMPTY_VALUE;
               ggibuf_216[i] = EMPTY_VALUE;
            }
         }
      }
   }
   return (0);
}